// google chart constructor loader
google.charts.load("current", {packages:["corechart", "table", "pie"]});
// chart render based on data.
innGrid.drawChart = function(chartData) {

	var options = {
		title: "",
		pieHole: 0.35,
		pieSliceBorderColor: "none",
		legend: {
			position: "left"
		},
		pieSliceText: "none",
		height: 300
	};
	data = new google.visualization.DataTable();
	data.addColumn('string', 'Type');
	data.addColumn('number', 'Bookings');
	data.addRows(chartData);
	var chart = new google.visualization.PieChart(document.getElementById('source_chart'));
	chart.draw(data, options);
};
// Generate report table
innGrid.getTable = function(data) {
	$("#report-content").html("");

	var chartData = [];

	// render the report table's body
	$.each(data, function(index, value) {

		var chargeTotal = parseFloat(value.charge_total).toFixed(2);
		var roomChargeTotal = parseFloat(value.room_charge_total).toFixed(2);
		var commissionTotal = parseFloat(value.commission).toFixed(2);

		var row = $("<tr>", {
			"class": "sourceRow "
		}).append(
			$("<td>", {
				"class": "text-left",
				html: value.booking_source
			})
		).append(
			$("<td>", {
				"class": "text-center",
				html: "<span class='booking-count'>"+value.booking_count+"</span>"
			})
		).append(
			$("<td>", {
				"class": "text-right revPAR",
				text: value.revPAR.toFixed(2)
			})
		).append(
			$("<td>", {
				"class": "text-right ADR",
				text: isNaN(roomChargeTotal/value.booking_count) ? '0.00' : (roomChargeTotal/value.booking_count).toFixed(2)
				//value.ADR.toFixed(2)
			})
		).append(
			$("<td>", {
				"class": "text-right room-charge-total",
				text: roomChargeTotal
			})
		).append(
			$("<td>", {
				"class": "text-right charge-total",
				text: chargeTotal
			})
		).append(
			$("<td>", {
				"class": "text-right commission-total",
				text: commissionTotal
			})
		);

		$("#report-content").append(row);

		chartData.push([value.booking_source, parseInt(value.booking_count)]);
	});

	innGrid.drawChart(chartData);

	// occupancy total
	var bookingCountTotal = 0;
	$(".booking-count").each(function (data) {
		bookingCountTotal += parseFloat($(this).html().replace(/,/g, ''));
	});
	$("#monthly-booking-count-total").html(bookingCountTotal);

	// revPar average
	var revPARTotal = 0;
	var count = 0;
	$(".revPAR").each(function (data) {
		revPARTotal += parseFloat($(this).html().replace(/,/g, ''));
		count++;
	});
	$("#monthly-revPAR-average").html((revPARTotal/count).toFixed(2));

	// get charge total
	var roomChargeTotal = 0;
	$(".room-charge-total").each(function (data) {
		roomChargeTotal += parseFloat($(this).html().replace(/,/g, ''));
	});
	$("#monthly-room-charge-total").html(innGrid.addCommas(roomChargeTotal.toFixed(2)));

	$("#monthly-ADR-average").html((roomChargeTotal/bookingCountTotal).toFixed(2));

	// get charge total
	var chargeTotal = 0;
	$(".charge-total").each(function (data) {
		chargeTotal += parseFloat($(this).html().replace(/,/g, ''));
	});

	$("#monthly-charge-total").html(innGrid.addCommas(chargeTotal.toFixed(2)));

	// get commission total
	var commissionTotal = 0;
	$(".commission-total").each(function (data) {
		commissionTotal += parseFloat($(this).html().replace(/,/g, ''));
	});

	$("#monthly-commission-total").html(innGrid.addCommas(commissionTotal.toFixed(2)));
}


innGrid.renderReport = function(dateStart, dateEnd, groupBy, url = null) {
	
	if (dateStart != "" && dateEnd != "")
	{
		if(url){
                    var url = 'download_booking_source_csv_export';
                }else{
                    var url = 'get_booking_source_data_AJAX';
                }
		$.ajax({
			type: "POST",
			url: getBaseURL() + "reports/market_segment/"+url+"/",
			data: { 
				dateStart: dateStart,
				dateEnd: dateEnd,
				groupBy: groupBy
			},
			dataType: "json",
			success: function( data ) {
				innGrid.getTable(data);
			}
		});
	}


}


$(function() {

	$("#dateStart, #dateEnd").datepicker({ dateFormat: 'yy-mm-dd' });

	var dateStart = $("#dateStart").val();
	var dateEnd = $("#dateEnd").val();
	var groupBy = $("#groupBy").val();
	
	innGrid.renderReport(dateStart, dateEnd, groupBy);

	$('#printReportButton').click(function (){

		dateStart = $("#dateStart").val();
		dateEnd = $("#dateEnd").val();

		var printContent = l('showing_data_between') + ' ' + dateStart + ' and ' + dateEnd;
		$('.visible-print-block').html(printContent);

		window.print();
	});

	$("#generateReport").on('click', function() {	
		var dateStart = $("#dateStart").val();
		var dateEnd = $("#dateEnd").val();
		var groupBy = $("#groupBy").val();
		
		innGrid.renderReport(dateStart, dateEnd, groupBy);
	});
        
        $("#downloadBookingReport").on('click', function() {	
		var dateStart = $("#dateStart").val();
		var dateEnd = $("#dateEnd").val();
		var groupBy = $("#groupBy").val();
		
                window.location.href = getBaseURL() + "reports/market_segment/download_booking_source_csv_export/"+dateStart+"/"+dateEnd+"/"+groupBy;
		innGrid.renderReport(dateStart, dateEnd, groupBy, true);
	});
        
	
});